/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000				*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 11Jul2000:	ACR	First version - tested on Linux only.		*/
/************************************************************************/

#include "stralloc.h"
#include "hash_core.h"
#include "noddylib.h"
#include "substdio.h"
#include "subfd.h"
#include "strerr.h"
#include "fmt.h"

int main( int argc, char *argv[] )
{
  if ( argc != 2)
    strerr_die3x(11,"Error: Wrong no. of arguments.\nUsage: ", \
                                            argv[0]," <string_to_hash>\n");
  else
  {
    stringclean(argv[1]);
    if (not_hashable(argv[1]))
      strerr_die1x(12,"Error: Malformed string given (invalid chars or too long).");
    else
      print_hashdir(argv[1]);
  }
}
