/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000 except hash function.		*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained */
/*		in the file gpl.txt supplied along with this program.	*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 11Jul2000:	ACR First version - tested on Linux only.		*/
/* 24Jul2000:	ACR Replaced multiplication function with hashpjw	*/
/************************************************************************/
/* Notes:	Hashing algorithm by Weinberger, see Aho, Sethi, Ullman	*/
/*		Compilers book 1986... or do a web search for hashpjw.	*/
/************************************************************************/

#include "noddylib.h"
#include "hash_core.h"
#include "../qmail-1.03/fmt.h"
#include "../qmail-1.03/str.h"
#include "../qmail-1.03/substdio.h"
#include "../qmail-1.03/subfd.h"

u4int gen_hash(char *s)
{ /* hashpjw is under GNU license; this version a hybrid of GNU & book	*/
  char *p;
  u4int h = 0, g;

  p = s;
  while (*p)
  {
    h = (h<<4) + *p++;
    g = h & 0xf0000000;
    if (g != 0)
    {
      h ^= (g>>24);
      h ^= g;
    }
  }
  return h;
}

void gen_string_hashes(char *s, char *s_h1, char *s_h2, char *s_h3)
{
  u4int h; int n;
  h = gen_hash(s);
  n=fmt_uint(s_h1,h%HASH1); s_h1[n]='\0'; h /= HASH1;
  n=fmt_uint(s_h2,h%HASH2); s_h2[n]='\0'; h /= HASH2;
  n=fmt_uint(s_h3,h%HASH3); s_h3[n]='\0';
};

void print_hashdir(char *s)
{
  char h[MAX_HASHDIR_LEN];

  get_hashdir(s,h);
  substdio_puts(subfdout,h);
  substdio_puts(subfdout,"\n");
  substdio_flush(subfdout);
}

void get_hashes_str(char *s, char *hashs)
{
  char h1[MAX_H1_LEN], h2[MAX_H2_LEN], h3[MAX_H3_LEN];

  gen_string_hashes(s,h1,h2,h3);
  hashs+=fmt_str(hashs,h1);
  hashs+=fmt_str(hashs,"/");
  hashs+=fmt_str(hashs,h2);
  hashs+=fmt_str(hashs,"/");
  hashs+=fmt_str(hashs,h3);
  hashs+=fmt_str(hashs,"/");
  hashs+=fmt_str(hashs,s);
  *hashs='\0';
}

void get_hashdir(char *s, char *hashd)
{

  hashd+=fmt_str(hashd,maildirs_basedir);
  hashd+=fmt_str(hashd,"/");
  get_hashes_str(s,hashd);
}

/* Validates s */
int not_hashable(char *s)
{
  if      (str_len(s) > MAX_HASHABLE_LEN)	return(4); /* too long	 */
  else if (str_len(s) == 0)			return(3); /* too short	 */
  else if (*s == '.')				return(2); /* starts with . */
  else if (!str_checkchars(s,HASHABLE_CH))	return(1); /* invalid ch */
  else						return(0); /* valid	 */
};
