/************************************************************************/
/* Copyright:	(c) Andrew Richards, 2000				*/
/************************************************************************/
/* License:	GNU General Public License version 2. This is contained	*/
/*		in the file gpl.txt supplied along with this program.	*/
/*		Note that the program uses libraries which are not	*/
/*		covered by the above license - contact the respective	*/
/*		license holders / copyright holders about these if reqd.*/
/************************************************************************/
/* Authors:	Andrew Richards andrew@tic.ch (Advert: I offer qmail	*/
/*		  consultancy services - ich spreche auch Deutsch)	*/
/************************************************************************/
/* 25Jul2000:	ACR	First version - tested on Linux only.		*/
/************************************************************************/
/* Description:	This program is designed to participate in a "chain" of	*/
/*		programs, specifically as part of a qmail-popup /	*/
/*		checkpassword / chhashdir / qmail-pop3d sequence. This	*/
/*		approach has the advantage of being independent of	*/
/*		checkpassword. The program purely does an appropriate	*/
/*		chdir to the hashed directory before treating its	*/
/*		arguments as a command to execvp. If the hashed		*/
/*		directory doesn't exist, the program exits 1. Note that	*/
/*		an alternative approach would be to set $HOME instead,	*/
/*		and leave the chdir-ing to the invoked program.		*/
/************************************************************************/

#include <unistd.h>
#include "hash_core.h"
#include "noddylib.h"

int main( int argc, char *argv[] )
{
  char hashdir[MAX_HASHDIR_LEN], *u;
  if (!argv[1]) return(2);			   /* No subprog given	*/
  if ((u=(char*)env_get("USER"))==NULL) return(2); /* USER not set	*/
  stringclean(u);				   /* lower case etc.	*/
  if (not_hashable(u)) return(2);		   /* Invalid chars,len	*/
  get_hashdir(u,hashdir);
  if (chdir(hashdir) == 0)
  {
   execvp(argv[1],argv + 1);
   return(111);					   /* Couldn't exec	*/
  }
  else						   /* Couldn't chdir	*/
    return(1);
}
